<?php
namespace lib\field;

class TextArea extends \lib\Field
{
	public $type = 'textarea';
	
	public function __construct($name, $validation=array(), $value='')
	{
		$this->name = $name;
		$this->value = get_magic_quotes_gpc()?stripslashes($value):$value;
		$this->validation = $validation;
	}
	
	public function input()
	{
		return '<textarea class="textarea" name="'.$this->name.'['.$this->form->bulk.']">'.$this->value.'</textarea>';
	}
}